//
//  ViewController.swift
//  Citizen PSample 1 Swift
//
//  Created on 2015/08/11.
//  Copyright (c) 2015年 CITIZEN. All rights reserved.
//

import UIKit
import CSJPOSLibSwift

class ViewController: UIViewController, UITextFieldDelegate {

    @IBOutlet weak var segmentPortType: UISegmentedControl!
    @IBOutlet weak var editText_Address_Wifi: UITextField!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
        editText_Address_Wifi.returnKeyType = UIReturnKeyType.done
        editText_Address_Wifi.delegate = self
        
        segmentPortType.selectedSegmentIndex = 0
        
        editText_Address_Wifi.text = ""
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
        
    }
    
    func messageBox(_ message: String, withTitle title: String, withAutoDismiss dismiss: Bool){
        let alert = UIAlertView()
        alert.title = title
        alert.message = message
        
        if dismiss == true {
            alert.show()
            RunLoop.current.run(until: Date(timeIntervalSinceNow: 1.5))
            alert.dismiss(withClickedButtonIndex: 0, animated: false)
        } else {
            alert.addButton(withTitle: "OK")
            alert.show()
        }
    }

    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        
        editText_Address_Wifi.resignFirstResponder()
        return true
    }
    
    @IBAction func onClick_button_SamplePrint01_Wifi(_ sender: AnyObject) {
        
        var posPtr: ESCPOSPrinter? = CSJPOSLibSwift.ESCPOSPrinter()
        
        // get address
        let addr = editText_Address_Wifi.text
        
        var result: Int32 = 0
        
        // connect
        if segmentPortType.selectedSegmentIndex == 0 {
            result = posPtr!.connect(CMP_PORT_BLUETOOTH, withAddrress: addr)
        } else {
            result = posPtr!.connect(CMP_PORT_WiFi, withAddrress: addr)
        }
        
        if CMP_SUCCESS == result {
            // character set
            _ = posPtr!.setEncoding(String.Encoding.isoLatin1)    // latin-1
            //posPtr!.setEncoding(NSISOLatin1StringEncoding)  // japanese shift-jis
            
            // start transaction (batch)
            _ = posPtr!.transactionPrint(CMP_TP_TRANSACTION)
            
            let infoDictionary = Bundle.main.localizedInfoDictionary! as Dictionary
            let appName = infoDictionary["CFBundleDisplayName"]! as! String
            
            // printText
            _ = posPtr!.printText("\(appName)\n\n", withAlignment:CMP_ALIGNMENT_CENTER, withAttribute:CMP_FNT_DEFAULT, withTextSize:CMP_TXT_1WIDTH|CMP_TXT_1HEIGHT)
            _ = posPtr!.printText("- Sample Print 1 -\n", withAlignment:CMP_ALIGNMENT_CENTER, withAttribute:CMP_FNT_DEFAULT, withTextSize:CMP_TXT_1WIDTH|CMP_TXT_2HEIGHT)
            _ = posPtr!.printText("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\n", withAlignment:CMP_ALIGNMENT_RIGHT, withAttribute:CMP_FNT_DEFAULT, withTextSize:CMP_TXT_1WIDTH|CMP_TXT_1HEIGHT)

            //printQRCode
            _ = posPtr!.printQRCode("http://www.citizen-systems.co.jp", withModuleSize:6, withECLevel:CMP_QRCODE_EC_LEVEL_L, withAlignment:CMP_ALIGNMENT_RIGHT)
            
            // partical cut with pre-feed
            _ = posPtr!.cutPaper(CMP_CUT_PARTIAL_PREFEED)
            
            // end transaction (batch)
            result = posPtr!.transactionPrint(CMP_TP_NORMAL)
            
            // discoonect
            _ = posPtr!.disconnect()
            
            if result != CMP_SUCCESS {
                messageBox("Transaction Error : \(result)", withTitle: "Error", withAutoDismiss: true)
            }
        } else {
            messageBox("Connect or Printer Error : \(result)", withTitle: "Error", withAutoDismiss: true)
        }
        
        posPtr = nil
    }

    @IBAction func onClick_button_SamplePrint02_Wifi(_ sender: AnyObject) {
        var posPtr: ESCPOSPrinter? = CSJPOSLibSwift.ESCPOSPrinter()
        
        // get address
        let addr = editText_Address_Wifi.text
        
        var result: Int32 = 0
        
        // connect
        if segmentPortType.selectedSegmentIndex == 0 {
            result = posPtr!.connect(CMP_PORT_BLUETOOTH, withAddrress: addr)
        } else {
            result = posPtr!.connect(CMP_PORT_WiFi, withAddrress: addr)
        }
        
        if CMP_SUCCESS == result {
            // character set
            _ = posPtr!.setEncoding(String.Encoding.isoLatin1)    // latin-1
            //posPtr!.setEncoding(NSISOLatin1StringEncoding)  // japanese shift-jis
            
            // start transaction (batch)
            _ = posPtr!.transactionPrint(CMP_TP_TRANSACTION)
            
            let infoDictionary = Bundle.main.localizedInfoDictionary! as Dictionary
            let appName = infoDictionary["CFBundleDisplayName"]! as! String
            
            // printText
            _ = posPtr!.printText("\(appName)\n\n", withAlignment:CMP_ALIGNMENT_CENTER, withAttribute:CMP_FNT_DEFAULT, withTextSize:CMP_TXT_1WIDTH|CMP_TXT_1HEIGHT)
            let sample2 = String(format: "%c|2vC%c|cA- Sample Print 2 -\n", 27, 27)
            _ = posPtr!.printNormal(sample2)
            _ = posPtr!.printText("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\n", withAlignment:CMP_ALIGNMENT_RIGHT, withAttribute:CMP_FNT_DEFAULT, withTextSize:CMP_TXT_1WIDTH|CMP_TXT_1HEIGHT)
            
            // start page mode
            _ = posPtr!.pageModePrint(CMP_PM_PAGE_MODE)
            
            // set offset value in pagemode
            _ = posPtr!.setPageModeVerticalPosition(0)
            _ = posPtr!.setPageModeHorizontalPosition(0)
            
            // set print direction in pagemode
            _ = posPtr!.setPageModePrintDirection(CMP_PD_TOP_TO_BOTTOM)
            
            // set printable area in pagemode
            _ = posPtr!.setPageModePrintArea("500,0,76,800" )
            
            let receipt = String(format: "%c|4C- Receipt -\n", 27)
            _ = posPtr!.printNormal(receipt)
            _ = posPtr!.setPageModePrintArea("260,0,120,800")
            _ = posPtr!.printText("$ 299.99- \n", withAlignment:CMP_ALIGNMENT_CENTER, withAttribute:CMP_FNT_UNDERLINE|CMP_FNT_BOLD, withTextSize:CMP_TXT_4WIDTH|CMP_TXT_4HEIGHT)
            _ = posPtr!.setPageModePrintArea("88,0,88,560")
            _ = posPtr!.printText(" CITIZEN SYSTEMS\n", withAlignment:CMP_ALIGNMENT_RIGHT, withAttribute:CMP_FNT_DEFAULT, withTextSize:CMP_TXT_2WIDTH|CMP_TXT_3HEIGHT)
            //posPtr!.setPageModePrintArea: @"0,0,88,480")
            _ = posPtr!.setPageModePrintArea("0,0,98,480")
            _ = posPtr!.printBarCode("123456789012", withSymbology:CMP_BCS_UPCA, withHeight: 64, withWidth:4, withAlignment:CMP_ALIGNMENT_LEFT, withTextPosition:CMP_HRI_TEXT_BELOW)
            _ = posPtr!.setPageModePrintArea("0,600,192,192")
            _ = posPtr!.printQRCode("http://www.citizen-systems.co.jp/", withModuleSize :5, withECLevel:CMP_QRCODE_EC_LEVEL_L, withAlignment:CMP_ALIGNMENT_LEFT)
            
            // end page mode
            _ = posPtr!.pageModePrint(CMP_PM_NORMAL)
            
            // partical cut with pre-feed
            _ = posPtr!.cutPaper(CMP_CUT_PARTIAL_PREFEED)
            
            // end transaction (batch)
            result = posPtr!.transactionPrint(CMP_TP_NORMAL)
            
            // discoonect
            _ = posPtr!.disconnect()
            
            if result != CMP_SUCCESS {
                messageBox("Transaction Error : \(result)", withTitle: "Error", withAutoDismiss: true)
            }
        } else {
            messageBox("Connect or Printer Error : \(result)", withTitle: "Error", withAutoDismiss: true)
        }
        
        posPtr = nil
    }
}

